/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client.ui;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.client.DisconnectReason;
import com.iosoft.fgalpha.client.FGAClient;
import com.iosoft.fgalpha.client.Gamestate;
import com.iosoft.fgalpha.client.ui.MediaLib;
import com.iosoft.fgalpha.server.DedicatedInfo;
import com.iosoft.fgalpha.server.FGAServer;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.ui.GameSpinner;
import com.iosoftware.helpers.ui.GameText;
import com.iosoftware.helpers.ui.Picture;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UserInterface {
    public static final int APP_WIDTH = 800;
    public static final int APP_HEIGHT = 600;
    private Container content;
    private GameSpinner spinnerWeapon;
    private GameSpinner spinnerTeam;
    private GameSpinner spinnerExtra;
    private GameSpinner spinnerMap;
    private GameSpinner spinnerGamemode;
    private JDialog updateDlg;
    private JPanel ladescreen;
    private JPanel dediscreen;
    private JPanel connectscreen;
    private JPanel dcscreen;
    private JPanel hosting;
    private Picture mmscreen;
    private Picture picWeapon;
    private Picture picTeam;
    private Picture picExtra;
    private InputMgr inputMgr;
    private Drawscreen ds;
    private JButton buttonHost;
    private JButton buttonConnect;
    private JButton buttonJoinOfficial;
    private JButton buttonAbort;
    private JButton buttonBack;
    private JButton buttonCloseDedicated;
    private JButton buttonMinimizeDedicated;
    private JButton buttonQuit;
    private JButton buttonRespawn;
    private JTextField textName;
    private JTextField textIP;
    private JTextField textPort;
    private JTextField textHostPort;
    private JTextField textPlayers;
    private JTextField textBots;
    private JTextField textDedi;
    private JTextField textDediIP;
    private JLabel labelDcReason;
    private JLabel labelDcFrom;
    private JLabel labelConnectTo;
    private JLabel labelConnectState;
    private JCheckBox boxDedicated;
    private JCheckBox boxNetwork;
    private JCheckBox boxFF;
    private JEditorPane dediPlayers;
    private JEditorPane dediChat;
    private JTextArea textBug;
    private JScrollPane scrollerBug;
    private boolean connected;
    private JFrame window;
    private GraphicsDevice graphicsDevice;
    private DisplayMode fullscreenDisplayMode;
    private boolean fullscreened;
    private Gamestate gs;
    private SystemTray tray;
    private TrayIcon trayIcon;
    private final Runnable repainter;
    private static UserInterface inst;
    public static final int STEP_NONE = 0;
    public static final int STEP_CONNECTING = 1;
    public static final int STEP_W4G = 2;
    public static final int STEP_MAP = 3;
    public static boolean stopped;
    private Object lockStop = new Object();

    static {
        stopped = false;
    }

    public static UserInterface get() {
        if (inst == null) {
            inst = new UserInterface();
        }
        return inst;
    }

    public void init(Gamestate gamestate) {
        if (this.gs == null) {
            this.gs = gamestate;
            MediaLib.loadImportant();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Misc.setLF();
                    UserInterface.this.startUI();
                }
            });
            MediaLib.load();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserInterface.this.onLoaded();
                }
            });
        }
    }

    private UserInterface() {
        this.repainter = new Runnable(){

            @Override
            public void run() {
                UserInterface.this.ds.repaint();
            }
        };
    }

    public static void onError(Exception ex) {
        inst.onErrorPrivate(ex);
    }

    private void onErrorPrivate(final Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInterface.this.onErrorSwing(ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onErrorSwing(Exception ex) {
        Object object = this.lockStop;
        synchronized (object) {
            if (stopped) {
                return;
            }
            stopped = true;
        }
        FightgameAlpha.get().addToErrorLog("Game error", ex);
        FGAServer.get().stop();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = sw.toString();
        pw.close();
        this.textBug.setText("An unexpected error occured!\nPlease report this to the creator of the program!\n\n" + s);
        Container content = this.window.getContentPane();
        content.removeAll();
        content.add(this.scrollerBug);
        this.window.validate();
        this.window.repaint();
    }

    private void startUI() {
        this.fullscreened = false;
        this.fullscreenDisplayMode = null;
        try {
            this.graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            DisplayMode[] dms = this.graphicsDevice.getDisplayModes();
            int i = 0;
            while (i < dms.length) {
                if (dms[i].getWidth() == 800 && dms[i].getHeight() == 600 && dms[i].getBitDepth() == 32) {
                    this.fullscreenDisplayMode = dms[i];
                    break;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.graphicsDevice = null;
            this.fullscreenDisplayMode = null;
        }
        this.createUI();
    }

    public boolean canGoFullscreen() {
        return this.graphicsDevice != null && this.fullscreenDisplayMode != null;
    }

    private void setFullscreen(boolean doit) {
        if (this.canGoFullscreen()) {
            if (doit) {
                if (!this.fullscreened) {
                    this.window.dispose();
                    this.window.setUndecorated(true);
                    this.graphicsDevice.setFullScreenWindow(this.window);
                    this.graphicsDevice.setDisplayMode(this.fullscreenDisplayMode);
                    this.window.repaint();
                    this.fullscreened = true;
                }
            } else if (this.fullscreened) {
                this.window.dispose();
                this.window.setUndecorated(false);
                this.graphicsDevice.setFullScreenWindow(null);
                this.window.setVisible(true);
                this.window.repaint();
                this.fullscreened = false;
            }
        }
    }

    private void createUI() {
        this.textBug = new JTextArea();
        this.textBug.setEditable(false);
        this.scrollerBug = new JScrollPane(this.textBug);
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                UserInterface.this.inputMgr.stopKeys();
                UserInterface.this.inputMgr.resetKeys();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                UserInterface.this.inputMgr.stopKeys();
                UserInterface.this.inputMgr.resetKeys();
            }
        };
        this.inputMgr = new InputMgr();
        this.ds = new Drawscreen();
        this.ds.addFocusListener(fl);
        this.window = new JFrame("Fightgame Alpha v0.3.0");
        this.window.addFocusListener(fl);
        this.window.setIconImage(MediaLib.icon);
        this.window.setDefaultCloseOperation(3);
        this.window.setResizable(false);
        this.content = this.window.getContentPane();
        this.content.setPreferredSize(new Dimension(800, 600));
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.ladescreen = new JPanel();
        this.content.add(this.ladescreen);
        this.ladescreen.setLayout(null);
        this.ladescreen.setBounds(0, 0, 800, 600);
        this.ladescreen.setBackground(Color.WHITE);
        JLabel laden = new JLabel("Lade...");
        laden.setFont(MediaLib.font1);
        laden.setBounds(0, 0, 800, 600);
        laden.setHorizontalAlignment(0);
        laden.setVerticalAlignment(0);
        this.ladescreen.add(laden);
        Timer t = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserInterface.this.window.pack();
                UserInterface.this.window.setVisible(true);
            }
        });
        t.setRepeats(false);
        t.start();
    }

    private void onIngame() {
        MediaLib.playSound2 = true;
        this.buttonConnect.setText("Back to game");
        this.hosting.setVisible(false);
        this.buttonJoinOfficial.setVisible(false);
        this.textName.setEnabled(false);
        this.textIP.setEnabled(false);
        this.textPort.setEnabled(false);
        this.connected = true;
    }

    private void onQuit() {
        this.hosting.setVisible(true);
        this.buttonConnect.setText("Connect");
        this.buttonJoinOfficial.setVisible(true);
        this.textName.setEnabled(true);
        this.textIP.setEnabled(true);
        this.textPort.setEnabled(true);
        this.connected = false;
        this.inputMgr.resetKeys();
    }

    private void fromGameToMM() {
        MediaLib.playSound2 = false;
        this.inputMgr.resetKeys();
        this.content.remove(this.ds);
        this.content.add(this.mmscreen);
        this.build();
    }

    private void fromMMToGame() {
        MediaLib.playSound2 = true;
        this.content.remove(this.mmscreen);
        this.content.add(this.ds);
        this.setClientData();
        FGAClient.get().resendLoadout();
        this.build();
        this.ds.requestFocusInWindow();
    }

    private void setClientData() {
        FGAClient.get().setData(this.textName.getText(), this.spinnerWeapon.getChoice(), this.spinnerExtra.getChoice(), this.spinnerTeam.getChoice(), this.textIP.getText(), Misc.getAsInt(this.textPort.getText(), 2738));
    }

    private void onLoaded() {
        this.ds.postload();
        Dimension dim = this.ds.getToolkit().getBestCursorSize(40, 40);
        int x = (int)((float)dim.width / 2.0f);
        int y = (int)((float)dim.height / 2.0f);
        this.ds.setCursor(this.ds.getToolkit().createCustomCursor(MediaLib.crosshair, new Point(x, y), "sniperscope"));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (stopped) {
                    return;
                }
                try {
                    UserInterface.this.updateMM();
                    Object source = e.getSource();
                    if (source == UserInterface.this.buttonConnect) {
                        if (UserInterface.this.connected) {
                            UserInterface.this.fromMMToGame();
                        } else {
                            String ip = UserInterface.this.textIP.getText();
                            int port = Misc.getAsInt(UserInterface.this.textPort.getText().trim(), 2738);
                            UserInterface.this.setClientData();
                            FGAClient.get().connect(ip, port);
                            UserInterface.this.setConnecting(String.valueOf(ip) + ":" + port);
                        }
                    } else if (source == UserInterface.this.buttonJoinOfficial) {
                        UserInterface.this.setClientData();
                        FGAClient.get().connect(MediaLib.officialIP, MediaLib.officialPort);
                        UserInterface.this.setConnecting(String.valueOf(MediaLib.officialIP) + ":" + MediaLib.officialPort);
                    } else if (source == UserInterface.this.buttonHost) {
                        UserInterface.this.buttonCloseDedicated.setEnabled(true);
                        int port = Misc.getAsInt(UserInterface.this.textHostPort.getText().trim(), 2738);
                        if (UserInterface.this.boxDedicated.isSelected()) {
                            UserInterface.this.content.remove(UserInterface.this.mmscreen);
                            UserInterface.this.textDediIP.setText("IP: " + Misc.getExternalIP() + ":" + port);
                            UserInterface.this.content.add(UserInterface.this.dediscreen);
                            UserInterface.this.build();
                        } else {
                            UserInterface.this.setConnecting(null);
                        }
                        UserInterface.this.setClientData();
                        FightgameAlpha.get().startServerAndConnect(UserInterface.this.boxNetwork.isSelected(), port, Integer.parseInt(UserInterface.this.textPlayers.getText()), FightgameAlpha.get().getMaps()[UserInterface.this.spinnerMap.getChoice()], UserInterface.this.spinnerGamemode.getChoice(), UserInterface.this.boxFF.isSelected(), Integer.parseInt(UserInterface.this.textBots.getText()), UserInterface.this.boxDedicated.isSelected());
                    } else if (source == UserInterface.this.buttonBack) {
                        UserInterface.this.content.remove(UserInterface.this.dcscreen);
                        UserInterface.this.content.add(UserInterface.this.mmscreen);
                        UserInterface.this.build();
                    } else if (source == UserInterface.this.buttonRespawn) {
                        UserInterface.this.fromMMToGame();
                        FGAClient.get().chat("/kill");
                    } else if (source == UserInterface.this.buttonQuit) {
                        UserInterface.this.fromMMToGame();
                        UserInterface.this.buttonQuit.setVisible(false);
                        FGAClient.get().quit();
                    } else if (source == UserInterface.this.buttonAbort) {
                        FGAClient.get().abortConnecting();
                        UserInterface.this.buttonAbort.setEnabled(false);
                        UserInterface.this.build();
                    } else if (source == UserInterface.this.buttonCloseDedicated) {
                        FGAServer.get().stop();
                        UserInterface.this.content.remove(UserInterface.this.dediscreen);
                        UserInterface.this.content.add(UserInterface.this.mmscreen);
                    } else if (source == UserInterface.this.buttonMinimizeDedicated) {
                        if (UserInterface.this.tray != null) {
                            try {
                                UserInterface.this.tray.add(UserInterface.this.trayIcon);
                                UserInterface.this.window.dispose();
                            }
                            catch (AWTException ex) {
                                System.out.println("TrayIcon could not be added.");
                            }
                        }
                    } else if (source == UserInterface.this.textDedi) {
                        FGAServer.get().processChat(null, UserInterface.this.textDedi.getText());
                        UserInterface.this.textDedi.setText("");
                    } else if (source == UserInterface.this.ds.textChat) {
                        String msg = UserInterface.this.ds.textChat.getText().trim();
                        FGAClient.get().chat(msg);
                        UserInterface.this.ds.closeChat();
                    }
                }
                catch (Exception ex) {
                    UserInterface.this.onErrorSwing(ex);
                }
            }
        };
        this.ds.textChat.addActionListener(al);
        Font n = new Font("Verdana", 0, 15);
        Font nBold = new Font("Verdana", 1, 15);
        try {
            this.tray = SystemTray.getSystemTray();
            this.trayIcon = new TrayIcon(MediaLib.icon2);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    UserInterface.this.tray.remove(UserInterface.this.trayIcon);
                    UserInterface.this.window.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dediscreen = new JPanel();
        this.dediscreen.setLayout(null);
        this.dediscreen.setBounds(0, 0, 800, 600);
        this.textDediIP = new JTextField();
        this.textDediIP.setBackground(Color.WHITE);
        this.textDediIP.setEditable(false);
        this.textDediIP.setFont(n);
        this.textDediIP.setBounds(500, 70, 280, 30);
        this.textDediIP.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.dediscreen.add(this.textDediIP);
        this.dediPlayers = new JEditorPane("text/html", "");
        this.dediPlayers.setFont(n);
        this.dediPlayers.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane dediPlayersScroller = new JScrollPane(this.dediPlayers);
        dediPlayersScroller.setBounds(10, 150, 780, 440);
        this.dediscreen.add(dediPlayersScroller);
        this.buttonCloseDedicated = new JButton("Close server");
        this.buttonCloseDedicated.setFont(MediaLib.fontInput);
        this.buttonCloseDedicated.setOpaque(false);
        this.buttonCloseDedicated.setBounds(595, 15, 185, 40);
        this.buttonCloseDedicated.addActionListener(al);
        this.dediscreen.add(this.buttonCloseDedicated);
        this.buttonMinimizeDedicated = new JButton("Tray");
        this.buttonMinimizeDedicated.setFont(MediaLib.fontInput);
        this.buttonMinimizeDedicated.setOpaque(false);
        this.buttonMinimizeDedicated.setBounds(500, 15, 80, 40);
        this.buttonMinimizeDedicated.addActionListener(al);
        this.buttonMinimizeDedicated.setEnabled(SystemTray.isSupported() && this.tray != null);
        this.dediscreen.add(this.buttonMinimizeDedicated);
        this.textDedi = new JTextField();
        this.textDedi.setBounds(500, 110, 280, 30);
        this.textDedi.setText("");
        this.textDedi.setFont(MediaLib.fontInput);
        this.textDedi.addActionListener(al);
        this.dediscreen.add(this.textDedi);
        this.dediChat = new JEditorPane("text/plain", "");
        this.dediChat.setEditable(false);
        this.dediChat.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane dediChatScroller = new JScrollPane(this.dediChat);
        dediChatScroller.setBounds(10, 10, 480, 130);
        this.dediscreen.add(dediChatScroller);
        FightgameAlpha game = FightgameAlpha.get();
        JLabel labelVersion = new JLabel("Fightgame Alpha v0.3.0 / IoLib v1.3.0 \u00a9 Io Software");
        labelVersion.setForeground(new Color(0, 0, 100));
        labelVersion.setHorizontalAlignment(0);
        labelVersion.setFont(MediaLib.fontInfo);
        labelVersion.setBounds(0, 75, 800, 30);
        this.picWeapon = new Picture(20, 170, 300, 100);
        this.picWeapon.setBorder(BorderFactory.createLoweredBevelBorder());
        this.spinnerWeapon = new GameSpinner(20, 270, 300, 30, game.getWeapons(), "", nBold, game.getWeapon());
        this.spinnerWeapon.addActionListener(al);
        this.picExtra = new Picture(20, 310, 300, 100);
        this.picExtra.setBorder(BorderFactory.createLoweredBevelBorder());
        this.spinnerExtra = new GameSpinner(20, 410, 300, 30, game.getExtras(), "", nBold, game.getExtra());
        this.spinnerExtra.addActionListener(al);
        this.picTeam = new Picture(20, 450, 300, 100);
        this.picTeam.setBorder(BorderFactory.createLoweredBevelBorder());
        this.spinnerTeam = new GameSpinner(20, 550, 300, 30, game.getTeams(), "", nBold, game.getTeam());
        this.spinnerTeam.addActionListener(al);
        JLabel labelName = new JLabel("Callsign:");
        labelName.setFont(nBold);
        labelName.setBounds(20, 120, 100, 40);
        this.textName = new JTextField();
        this.textName.setBounds(120, 120, 200, 40);
        this.textName.setText(game.getName());
        this.textName.setFont(MediaLib.fontInput);
        this.textName.setHorizontalAlignment(0);
        JLabel labelIP = new JLabel("IP:");
        labelIP.setFont(nBold);
        labelIP.setBounds(350, 120, 40, 40);
        this.textIP = new JTextField();
        this.textIP.setBounds(390, 120, 270, 40);
        this.textIP.setText(game.getIP());
        this.textIP.setFont(MediaLib.fontInput);
        this.textIP.setHorizontalAlignment(0);
        JLabel labelPort = new JLabel(":");
        labelPort.setFont(nBold);
        labelPort.setHorizontalAlignment(0);
        labelPort.setBounds(660, 120, 20, 40);
        this.textPort = new JTextField();
        this.textPort.setBounds(680, 120, 100, 40);
        this.textPort.setText("" + game.getPort());
        this.textPort.setFont(MediaLib.fontInput);
        this.textPort.setHorizontalAlignment(0);
        this.buttonConnect = new JButton("Connect");
        this.buttonConnect.setFont(MediaLib.fontInput);
        this.buttonConnect.setOpaque(false);
        this.buttonConnect.setBounds(350, 175, 200, 50);
        this.buttonConnect.addActionListener(al);
        this.buttonJoinOfficial = new JButton("Searching...");
        this.buttonJoinOfficial.setFont(MediaLib.fontInput);
        this.buttonJoinOfficial.setOpaque(false);
        this.buttonJoinOfficial.setBounds(560, 175, 220, 50);
        this.buttonJoinOfficial.addActionListener(al);
        this.checkOfficialServerButton();
        this.buttonQuit = new JButton("Quit game");
        this.buttonQuit.setFont(MediaLib.fontInput);
        this.buttonQuit.setOpaque(false);
        this.buttonQuit.setVisible(false);
        this.buttonQuit.setBounds(480, 530, 300, 50);
        this.buttonQuit.addActionListener(al);
        this.buttonRespawn = new JButton("Respawn");
        this.buttonRespawn.setFont(MediaLib.fontInput);
        this.buttonRespawn.setOpaque(false);
        this.buttonRespawn.setVisible(false);
        this.buttonRespawn.setBounds(560, 175, 220, 50);
        this.buttonRespawn.addActionListener(al);
        this.hosting = new JPanel();
        this.hosting.setBackground(new Color(245, 245, 255));
        this.hosting.setBounds(350, 250, 430, 330);
        this.hosting.setLayout(null);
        JLabel labelHosting = new JLabel("Hosting a local server");
        labelHosting.setFont(MediaLib.font1);
        labelHosting.setBounds(0, 0, 430, 50);
        labelHosting.setHorizontalAlignment(0);
        this.boxNetwork = new JCheckBox("Network");
        this.boxNetwork.addActionListener(al);
        this.boxNetwork.setFont(nBold);
        this.boxNetwork.setOpaque(false);
        this.boxNetwork.setSelected(game.getNetwork());
        this.boxNetwork.setBounds(10, 60, 120, 40);
        this.boxDedicated = new JCheckBox("Dedicated");
        this.boxDedicated.addActionListener(al);
        this.boxDedicated.setFont(nBold);
        this.boxDedicated.setOpaque(false);
        this.boxDedicated.setSelected(game.getDedicated());
        this.boxDedicated.setBounds(130, 60, 120, 40);
        JLabel labelHostPort = new JLabel("Port:");
        labelHostPort.setFont(nBold);
        labelHostPort.setBounds(270, 60, 50, 40);
        this.textHostPort = new JTextField();
        this.textHostPort.setBounds(320, 60, 100, 40);
        this.textHostPort.setText("" + game.getHostPort());
        this.textHostPort.setFont(MediaLib.fontInput);
        this.textHostPort.setHorizontalAlignment(0);
        JLabel labelPlayers = new JLabel("Players:");
        labelPlayers.setFont(nBold);
        labelPlayers.setBounds(15, 110, 80, 40);
        this.textPlayers = new JTextField();
        this.textPlayers.setBounds(95, 110, 70, 40);
        this.textPlayers.setText("" + game.getPlayers());
        this.textPlayers.setFont(MediaLib.fontInput);
        this.textPlayers.setHorizontalAlignment(0);
        JLabel labelBots = new JLabel("Bots:");
        labelBots.setFont(nBold);
        labelBots.setBounds(230, 110, 80, 40);
        this.textBots = new JTextField();
        this.textBots.setBounds(310, 110, 70, 40);
        this.textBots.setText("" + game.getBots());
        this.textBots.setFont(MediaLib.fontInput);
        this.textBots.setHorizontalAlignment(0);
        JLabel labelMap = new JLabel("Map:");
        labelMap.setFont(nBold);
        labelMap.setBounds(15, 160, 80, 40);
        this.spinnerMap = new GameSpinner(95, 165, 300, 30, game.getMaps(), "", nBold, game.getMapAsChoice());
        this.spinnerMap.addActionListener(al);
        JLabel labelGamemode = new JLabel("Gamemode:");
        labelGamemode.setFont(nBold);
        labelGamemode.setBounds(15, 210, 100, 40);
        this.spinnerGamemode = new GameSpinner(120, 215, 155, 30, game.getGamemodes(), "", nBold, game.getGamemode());
        this.spinnerGamemode.addActionListener(al);
        this.boxFF = new JCheckBox("Friendly Fire");
        this.boxFF.addActionListener(al);
        this.boxFF.setFont(nBold);
        this.boxFF.setOpaque(false);
        this.boxFF.setSelected(game.getFriendlyFire());
        this.boxFF.setBounds(280, 210, 140, 40);
        this.buttonHost = new JButton("Start server");
        this.buttonHost.setFont(MediaLib.fontInput);
        this.buttonHost.setOpaque(false);
        this.buttonHost.setBounds(20, 270, 390, 40);
        this.buttonHost.addActionListener(al);
        this.hosting.add(labelHosting);
        this.hosting.add(this.boxNetwork);
        this.hosting.add(this.boxDedicated);
        this.hosting.add(labelHostPort);
        this.hosting.add(this.textHostPort);
        this.hosting.add(labelPlayers);
        this.hosting.add(this.textPlayers);
        this.hosting.add(labelBots);
        this.hosting.add(this.textBots);
        this.hosting.add(labelMap);
        this.hosting.add(this.spinnerMap);
        this.hosting.add(labelGamemode);
        this.hosting.add(this.spinnerGamemode);
        this.hosting.add(this.boxFF);
        this.hosting.add(this.buttonHost);
        this.connectscreen = new Picture(0, 0, 800, 600, MediaLib.mmBG);
        this.labelConnectTo = new JLabel("");
        this.labelConnectTo.setBounds(0, 125, 800, 100);
        this.labelConnectTo.setHorizontalAlignment(0);
        this.labelConnectTo.setForeground(new Color(150, 150, 0));
        this.labelConnectTo.setFont(MediaLib.fontBig);
        this.labelConnectState = new JLabel("");
        this.labelConnectState.setBounds(0, 250, 800, 100);
        this.labelConnectState.setFont(MediaLib.fontBig);
        this.labelConnectState.setHorizontalAlignment(0);
        this.buttonAbort = new JButton("Abort connecting");
        this.buttonAbort.setFont(MediaLib.fontInput);
        this.buttonAbort.setOpaque(false);
        this.buttonAbort.setBounds(150, 450, 500, 50);
        this.buttonAbort.addActionListener(al);
        this.connectscreen.add(this.labelConnectTo);
        this.connectscreen.add(this.labelConnectState);
        this.connectscreen.add(this.buttonAbort);
        this.dcscreen = new Picture(0, 0, 800, 600, MediaLib.mmBG);
        this.labelDcFrom = new JLabel("");
        this.labelDcFrom.setBounds(0, 125, 800, 100);
        this.labelDcFrom.setHorizontalAlignment(0);
        this.labelDcFrom.setForeground(new Color(150, 0, 0));
        this.labelDcFrom.setFont(MediaLib.fontBig);
        this.labelDcReason = new JLabel("");
        this.labelDcReason.setBounds(0, 250, 800, 100);
        this.labelDcReason.setFont(MediaLib.fontBig);
        this.labelDcReason.setHorizontalAlignment(0);
        this.buttonBack = new JButton("Back to main menu");
        this.buttonBack.setFont(MediaLib.fontInput);
        this.buttonBack.setOpaque(false);
        this.buttonBack.setBounds(150, 450, 500, 50);
        this.buttonBack.addActionListener(al);
        this.dcscreen.add(this.labelDcFrom);
        this.dcscreen.add(this.labelDcReason);
        this.dcscreen.add(this.buttonBack);
        this.mmscreen = new Picture(0, 0, 800, 600, MediaLib.mmBG);
        this.mmscreen.add(new Picture(100, 4, MediaLib.title));
        this.mmscreen.add(labelVersion);
        this.mmscreen.add(labelName);
        this.mmscreen.add(this.textName);
        this.mmscreen.add(this.picWeapon);
        this.mmscreen.add(this.spinnerWeapon);
        this.mmscreen.add(this.picExtra);
        this.mmscreen.add(this.spinnerExtra);
        this.mmscreen.add(this.picTeam);
        this.mmscreen.add(this.spinnerTeam);
        this.mmscreen.add(labelIP);
        this.mmscreen.add(this.textIP);
        this.mmscreen.add(labelPort);
        this.mmscreen.add(this.textPort);
        this.mmscreen.add(this.buttonConnect);
        this.mmscreen.add(this.buttonJoinOfficial);
        this.mmscreen.add(this.hosting);
        this.mmscreen.add(this.buttonQuit);
        this.mmscreen.add(this.buttonRespawn);
        this.content.remove(this.ladescreen);
        this.content.add(this.mmscreen);
        this.updateMM();
        if (this.updateDlg != null) {
            this.updateDlg.requestFocus();
        }
    }

    private void updateMM() {
        int weapon = this.spinnerWeapon.getChoice();
        if (weapon == 4) {
            this.picWeapon.setImage(MediaLib.teams[0]);
        } else {
            this.picWeapon.setImage(MediaLib.weapons[weapon]);
        }
        int extra = this.spinnerExtra.getChoice();
        if (extra == 6) {
            this.picExtra.setImage(MediaLib.teams[0]);
        } else {
            this.picExtra.setImage(MediaLib.extras[extra]);
        }
        int team = this.spinnerTeam.getChoice();
        this.picTeam.setImage(MediaLib.teams[team]);
        this.boxDedicated.setEnabled(this.boxNetwork.isSelected());
        this.textHostPort.setEnabled(this.boxNetwork.isSelected());
        this.boxFF.setEnabled(this.spinnerGamemode.getChoice() == 1);
        this.build();
    }

    public void setIngame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInterface.this.buttonQuit.setVisible(true);
                UserInterface.this.buttonRespawn.setVisible(true);
                UserInterface.this.inputMgr.resetKeys();
                UserInterface.this.ds.closeChat();
                UserInterface.this.content.remove(UserInterface.this.connectscreen);
                UserInterface.this.content.add(UserInterface.this.ds);
                UserInterface.this.onIngame();
                UserInterface.this.build();
                UserInterface.this.ds.requestFocusInWindow();
            }
        });
    }

    private void setConnecting(String to) {
        this.buttonAbort.setEnabled(true);
        this.labelConnectState.setText(this.getStepAsText(0));
        this.labelConnectTo.setText(to == null ? "local server" : to);
        this.labelDcFrom.setText(to == null ? "local server" : to);
        this.content.remove(this.ds);
        this.content.remove(this.mmscreen);
        this.content.add(this.connectscreen);
        this.build();
    }

    private void build() {
        this.window.validate();
        this.window.repaint();
    }

    public void setConnectionStep(final int step) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInterface.this.labelConnectState.setText(UserInterface.this.getStepAsText(step));
                UserInterface.this.build();
            }
        });
    }

    private String getStepAsText(int step) {
        switch (step) {
            case 0: {
                return "Starting connection...";
            }
            case 1: {
                return "Connecting...";
            }
            case 2: {
                return "Waiting for server...";
            }
            case 3: {
                return "Receiving map...";
            }
        }
        return "?";
    }

    public void reconnect() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ((UserInterface)UserInterface.this).gs.lock;
                synchronized (object) {
                    UserInterface.this.setConnecting(((UserInterface)UserInterface.this).gs.serverLocal ? null : String.valueOf(((UserInterface)UserInterface.this).gs.serverIP) + ":" + ((UserInterface)UserInterface.this).gs.serverPort);
                }
            }
        });
    }

    public void setDisconnected(final DisconnectReason reason) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String version = ((UserInterface)UserInterface.this).gs.serverVersion;
                UserInterface.this.buttonQuit.setVisible(false);
                UserInterface.this.buttonRespawn.setVisible(false);
                UserInterface.this.labelDcReason.setText(reason.getAsText(version));
                UserInterface.this.content.remove(UserInterface.this.ds);
                UserInterface.this.content.remove(UserInterface.this.connectscreen);
                UserInterface.this.content.remove(UserInterface.this.mmscreen);
                UserInterface.this.content.add(UserInterface.this.dcscreen);
                UserInterface.this.onQuit();
                UserInterface.this.build();
            }
        });
    }

    public void drawGame() {
        SwingUtilities.invokeLater(this.repainter);
    }

    public void setDedicatedInfo(final DedicatedInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder text = new StringBuilder();
                text.append("<html><body>");
                int iC = info.players.length;
                text.append("<h2>Players: " + info.numHumans + " / " + info.maxPlayers + " + " + (iC - info.numHumans) + " Bots - " + info.time2String() + " - Objs: " + info.numObjs + "</h2>");
                text.append("# - Name - IP - Ping - Admin - Kills - Deaths - Version<br>");
                int i = 0;
                while (i < iC) {
                    DedicatedInfo.Player p = info.players[i];
                    text.append(p.nr + " - ");
                    if (p.name == null) {
                        text.append("Connecting: " + p.ip + "<br>");
                    } else {
                        text.append(String.valueOf(p.name.replace("<", "&lt;").replace(">", "&gt;")) + " - " + (p.ip == null ? "[BOT]" : p.ip) + " - " + p.ping + " - " + p.admin + " - " + p.kills + " - " + p.deaths + " - " + (p.version == null ? "v0.3.0" : p.version) + "<br>");
                    }
                    ++i;
                }
                text.append("</body></html>");
                UserInterface.this.dediPlayers.setText(text.toString());
                UserInterface.this.trayIcon.setToolTip("Fightgame Alpha v0.3.0 Dedicated Server\n" + info.time2String() + "\n" + info.mapname + " - " + (info.gamemode == 1 ? "Teams" : "Deathmatch") + "\n" + info.numHumans + " / " + info.maxPlayers);
            }
        });
    }

    public void addChat(final String chatMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String chat = String.valueOf(UserInterface.this.dediChat.getText()) + "\n" + chatMsg;
                if (chat.length() > 500) {
                    chat = chat.substring(chat.length() - 500);
                }
                UserInterface.this.dediChat.setText(chat);
            }
        });
    }

    public void onOfficialServerLoaded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UserInterface.this.checkOfficialServerButton();
            }
        });
    }

    public void onUpdateFound() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaLib.playSound(26);
                JDialog dlg = new JDialog(null, "Update available!");
                dlg.setResizable(false);
                dlg.setDefaultCloseOperation(2);
                Container content = dlg.getContentPane();
                content.setLayout(null);
                content.setPreferredSize(new Dimension(400, 200));
                final JLabel info = new JLabel("There's an update for FGA!");
                info.setBounds(5, 0, 380, 40);
                info.setFont(MediaLib.fontUi);
                content.add(info);
                JLabel icon = new JLabel(new ImageIcon(MediaLib.crosshair));
                icon.setBounds(10, 45, 60, 60);
                content.add(icon);
                JLabel name = new JLabel("FGA " + MediaLib.newUpdateName);
                name.setBounds(80, 45, 325, 60);
                name.setFont(MediaLib.fontUiBig);
                content.add(name);
                JButton button = new JButton("Go to download page");
                button.setBounds(25, 130, 350, 50);
                button.setFont(MediaLib.fontUi);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI("http://para-welt.com/main/ayce/fgalpha/"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                content.add(button);
                dlg.pack();
                dlg.setLocationRelativeTo(null);
                final Timer t = new Timer(1, new ActionListener(){
                    int step = 0;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ++this.step;
                        if (this.step > 255) {
                            this.step = -254;
                        }
                        info.setForeground(new Color(Math.abs(this.step), 0, 0));
                    }
                });
                t.start();
                dlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        t.stop();
                    }
                });
                dlg.setVisible(true);
                UserInterface.this.updateDlg = dlg;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOfficialServerButton() {
        if (this.buttonJoinOfficial != null) {
            Object object = MediaLib.lock;
            synchronized (object) {
                if (MediaLib.officialDone) {
                    if (MediaLib.officialOffline) {
                        this.buttonJoinOfficial.setFont(MediaLib.fontPlayer);
                        this.buttonJoinOfficial.setText("Official Server OFFLINE");
                    } else {
                        this.buttonJoinOfficial.setText("Official Server");
                    }
                    this.window.repaint();
                }
                this.buttonJoinOfficial.setEnabled(MediaLib.officialIP != null && !MediaLib.officialOffline);
            }
        }
    }

    private class Drawscreen
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private GameText textChat = new GameText(30, 540, 540, 30, "", "");

        public Drawscreen() {
            this.textChat.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.textChat.setMaxChars(40);
            this.textChat.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int kc = e.getKeyCode();
                    if (kc == 27 || kc == 10) {
                        Drawscreen.this.closeChat();
                    }
                }
            });
            this.textChat.setVisible(false);
            this.add(this.textChat);
            this.setFocusTraversalKeysEnabled(false);
            this.setBounds(0, 0, 800, 600);
            this.setLayout(null);
            this.setFocusable(true);
            this.addKeyListener(UserInterface.this.inputMgr);
            this.addMouseListener(UserInterface.this.inputMgr);
            this.addMouseMotionListener(UserInterface.this.inputMgr);
        }

        public void postload() {
            this.textChat.setFont(MediaLib.fontInput);
        }

        public void openChat() {
            this.textChat.setText("");
            this.textChat.setVisible(true);
            this.textChat.requestFocusInWindow();
        }

        public void closeChat() {
            this.textChat.setVisible(false);
            this.requestFocusInWindow();
        }

        @Override
        public void paintComponent(Graphics gFake) {
            super.paintComponent(gFake);
            if (stopped) {
                return;
            }
            Graphics2D g = (Graphics2D)gFake;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            try {
                UserInterface.this.gs.render(g);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }
    }

    public class InputMgr
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        public static final int KEY_SCOREBOARD = 0;
        public boolean[] keys = new boolean[100];
        public boolean[] keys2 = new boolean[this.keys.length];

        public InputMgr() {
            this.resetKeys();
        }

        public void resetKeys() {
            int i = 0;
            while (i < this.keys.length) {
                this.keys[i] = false;
                this.keys2[i] = false;
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopKeys() {
            Object object = ((UserInterface)UserInterface.this).gs.lock;
            synchronized (object) {
                FGAClient.get().action(0, 0);
                FGAClient.get().action(1, 0);
                FGAClient.get().action(2, 0);
                FGAClient.get().action(3, 0);
                FGAClient.get().action(4, 0);
                FGAClient.get().action(5, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doMouse(MouseEvent e) {
            try {
                Object object = ((UserInterface)UserInterface.this).gs.lock;
                synchronized (object) {
                    ((UserInterface)UserInterface.this).gs.mouseAt.x = e.getX();
                    ((UserInterface)UserInterface.this).gs.mouseAt.y = e.getY();
                    FGAClient.get().mouseAction(e.getX() - 300, e.getY() - 300);
                }
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        private int getKey(int kc, int loc) {
            switch (kc) {
                case 87: {
                    return 0;
                }
                case 38: {
                    return 0;
                }
                case 83: {
                    return 1;
                }
                case 40: {
                    return 1;
                }
                case 65: {
                    return 2;
                }
                case 37: {
                    return 2;
                }
                case 68: {
                    return 3;
                }
                case 39: {
                    return 3;
                }
                case 82: {
                    return 5;
                }
                case 19: {
                    return 6;
                }
                case 9: {
                    return 80;
                }
                case 113: {
                    return 81;
                }
                case 116: {
                    return 82;
                }
                case 118: {
                    return 83;
                }
                case 114: {
                    return 84;
                }
                case 27: {
                    return 85;
                }
                case 10: {
                    return 86;
                }
            }
            return -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                this.doMouse(e);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            try {
                this.doMouse(e);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            try {
                this.doMouse(e);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                this.doMouse(e);
                FGAClient.get().action(4, 1);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                this.doMouse(e);
                FGAClient.get().action(4, 0);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent e) {
            int key = this.getKey(e.getKeyCode(), e.getKeyLocation());
            if (key != -1 && !this.keys[key]) {
                this.keys[key] = true;
                this.keys2[key] = true;
                Object object = ((UserInterface)UserInterface.this).gs.lock;
                synchronized (object) {
                    switch (key) {
                        case 80: {
                            ((UserInterface)UserInterface.this).gs.showScore = true;
                            break;
                        }
                        case 81: {
                            UserInterface.this.setFullscreen(!UserInterface.this.fullscreened);
                            break;
                        }
                        case 82: {
                            MediaLib.playSound = !MediaLib.playSound;
                            break;
                        }
                        case 83: {
                            ((UserInterface)UserInterface.this).gs.showRendertime = !((UserInterface)UserInterface.this).gs.showRendertime;
                            break;
                        }
                        case 84: {
                            Misc.makeScreenshot(UserInterface.this.ds, String.valueOf(FightgameAlpha.SETTINGS_PATH) + "screenshots/");
                            System.out.println("SS Taken");
                            break;
                        }
                        case 85: {
                            UserInterface.this.fromGameToMM();
                            break;
                        }
                        case 86: {
                            if (UserInterface.this.ds.textChat.isVisible()) break;
                            UserInterface.this.ds.openChat();
                            break;
                        }
                        default: {
                            FGAClient.get().action(key, 1);
                        }
                    }
                }
                UserInterface.this.ds.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent e) {
            int key = this.getKey(e.getKeyCode(), e.getKeyLocation());
            if (key != -1) {
                this.keys[key] = false;
                this.keys2[key] = false;
                if (key == 80) {
                    Object object = ((UserInterface)UserInterface.this).gs.lock;
                    synchronized (object) {
                        ((UserInterface)UserInterface.this).gs.showScore = false;
                    }
                } else {
                    FGAClient.get().action(key, 0);
                }
                UserInterface.this.ds.repaint();
            }
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                this.doMouse(e);
                FGAClient.get().action(4, 1);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            try {
                this.doMouse(e);
            }
            catch (Exception ex) {
                UserInterface.this.onErrorSwing(ex);
            }
        }
    }
}

