/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client.ui;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.client.ui.UserInterface;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.audio.SmallSound;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MediaLib {
    private static final float BASE_VOL = 1.0f;
    public static BufferedImage mapBG;
    public static BufferedImage fowcircle;
    public static BufferedImage mmBG;
    public static BufferedImage bullet;
    public static BufferedImage medkit;
    public static BufferedImage scoreDeaths;
    public static BufferedImage scoreAssists;
    public static BufferedImage scoreKills;
    public static BufferedImage scorePing;
    public static BufferedImage scoreDead;
    public static BufferedImage scoreAI;
    public static BufferedImage title;
    public static BufferedImage icon;
    public static BufferedImage icon2;
    public static BufferedImage crosshair;
    public static BufferedImage ui;
    public static BufferedImage uiAmmo;
    public static BufferedImage[] weapons;
    public static BufferedImage[] extras;
    public static BufferedImage[] teams;
    public static BufferedImage[] looks;
    public static BufferedImage[] scoreClass;
    public static BufferedImage[] team;
    public static BufferedImage[] scoreExtras;
    public static BufferedImage[] killfeedWeapons;
    public static BufferedImage[][] objects;
    public static Font fontScoreTitle;
    public static Font fontScore;
    public static Font fontScoreInfo;
    public static Font fontUi;
    public static Font fontUiBig;
    public static Font fontPlayer;
    public static Font font1;
    public static Font fontInput;
    public static Font fontBig;
    public static Font fontInfo;
    public static Font fontKillfeed;
    public static Object lock;
    public static String officialIP;
    public static String newUpdateName;
    public static int officialPort;
    public static boolean officialDone;
    public static boolean officialOffline;
    public static boolean loaded;
    private static SmallSound[] sounds;
    public static final int SOUND_SILENCE = 0;
    public static final int SOUND_BULLET_FLY = 1;
    public static final int SOUND_RELOAD_ASSAULT = 2;
    public static final int SOUND_RELOAD_SHOTGUN = 3;
    public static final int SOUND_RELOAD_SNIPER = 4;
    public static final int SOUND_RELOAD_MK14 = 5;
    public static final int SOUND_SHOT_ASSAULT = 6;
    public static final int SOUND_SHOT_ASSAULT2 = 7;
    public static final int SOUND_SHOT_SHOTGUN = 8;
    public static final int SOUND_SHOT_SNIPER = 9;
    public static final int SOUND_SHOT_MK14 = 10;
    public static final int SOUND_ASSAULTSHELL = 11;
    public static final int SOUND_SHOTGUNSHELL = 12;
    public static final int SOUND_SNIPERSHELL = 13;
    public static final int SOUND_MK14SHELL = 14;
    public static final int SOUND_IMPACT_FLESH1 = 15;
    public static final int SOUND_IMPACT_FLESH2 = 16;
    public static final int SOUND_IMPACT_FLESH3 = 17;
    public static final int SOUND_IMPACT_FLESH4 = 18;
    public static final int SOUND_IMPACT_WALL1 = 19;
    public static final int SOUND_IMPACT_WALL2 = 20;
    public static final int SOUND_IMPACT_WALL3 = 21;
    public static final int SOUND_IMPACT_WALL4 = 22;
    public static final int SOUND_PICKUP = 23;
    public static final int SOUND_CHAT = 24;
    public static final int SOUND_HITMARKER = 25;
    public static final int SOUND_UPDATE = 26;
    private static final String[] soundnames;
    public static boolean playSound;
    public static boolean playSound2;

    static {
        lock = new Object();
        loaded = false;
        soundnames = new String[]{"silence", "weapons/bullet_fly", "weapons/reload_assault", "weapons/reload_shotgun", "weapons/reload_sniper", "weapons/reload_mk14", "weapons/assault1", "weapons/assault2", "weapons/shotgun", "weapons/sniper", "weapons/mk14", "weapons/shells_assault", "weapons/shells_shotgun", "weapons/shells_sniper", "weapons/shells_mk14", "impact/flesh1", "impact/flesh2", "impact/flesh3", "impact/flesh4", "impact/wall1", "impact/wall2", "impact/wall3", "impact/wall4", "pickup", "chat", "hitmarker", "update"};
        playSound = true;
        playSound2 = true;
    }

    public static void loadImportant() {
        icon = Misc.loadImage("/res/icon.png");
        font1 = new Font("Verdana", 1, 25);
    }

    private static void startOfficialServerLoadThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String official = Misc.getFirstLine("http://para-welt.com/main/ayce/fgalpha/serverip.txt");
                if (official != null) {
                    int pat = official.indexOf(":");
                    Object object = lock;
                    synchronized (object) {
                        if (pat == -1) {
                            officialPort = 2738;
                            officialIP = official;
                        } else {
                            officialIP = official.substring(0, pat);
                            officialPort = Misc.getAsInt(official.substring(pat + 1));
                        }
                        officialDone = true;
                        if (officialIP.equals("offline")) {
                            officialOffline = true;
                        }
                        UserInterface.get().onOfficialServerLoaded();
                    }
                }
            }
        }, "Read official server").start();
        if (FightgameAlpha.get().shouldCheckForUpdates()) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String official = Misc.getFirstLine("http://para-welt.com/main/ayce/fgalpha/update.txt");
                    if (official != null) {
                        String[] tokens = official.split("\t");
                        Object object = lock;
                        synchronized (object) {
                            if (tokens.length >= 2 && tokens[0].equals("fgaupdate")) {
                                FightgameAlpha.get().onUpdateChecked();
                                newUpdateName = tokens[1];
                                MediaLib.checkDisplayUpdate();
                            }
                        }
                    }
                }
            }, "Update check").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkDisplayUpdate() {
        Object object = lock;
        synchronized (object) {
            if (newUpdateName != null && !newUpdateName.equals("v0.3.0") && loaded) {
                System.out.println("new version! " + newUpdateName);
                UserInterface.get().onUpdateFound();
            }
        }
    }

    public static void load() {
        MediaLib.startOfficialServerLoadThread();
        icon2 = Misc.loadImage("/res/icon2.png");
        title = Misc.loadImage("/res/client/menuicons/title.png");
        mmBG = Misc.loadImage("/res/client/mmbg.jpg");
        ui = Misc.loadImage("/res/client/ui.png");
        bullet = Misc.loadImage("/res/client/ui_ammo.png");
        uiAmmo = Misc.loadImage("/res/client/ui_ammo.png");
        medkit = Misc.loadImage("/res/client/map/medkit.png");
        fowcircle = Misc.loadImage("/res/client/fowcircle.png");
        scoreKills = Misc.loadImage("/res/client/score/kills.png");
        scoreDeaths = Misc.loadImage("/res/client/score/deaths.png");
        scoreAssists = Misc.loadImage("/res/client/score/assists.png");
        scorePing = Misc.loadImage("/res/client/score/extra_firepower.png");
        scoreDead = Misc.loadImage("/res/client/score/dead.png");
        scoreAI = Misc.loadImage("/res/client/score/ai.png");
        scoreExtras = Misc.loadImages("/res/client/score/extras.png", 7, 1);
        killfeedWeapons = Misc.loadImages("/res/client/score/killfeed_weapons.png", 1, 4);
        crosshair = Misc.loadImage("/res/client/crosshair.png");
        scoreClass = new BufferedImage[5];
        MediaLib.scoreClass[0] = Misc.loadImage("/res/client/score/assault.png");
        MediaLib.scoreClass[1] = Misc.loadImage("/res/client/score/shotgun.png");
        MediaLib.scoreClass[2] = Misc.loadImage("/res/client/score/sniper.png");
        MediaLib.scoreClass[3] = Misc.loadImage("/res/client/score/mk14.png");
        MediaLib.scoreClass[4] = Misc.loadImage("/res/client/score/unknown.png");
        objects = Misc.loadImages2("/res/client/map/objects.png", 12, 8);
        weapons = new BufferedImage[4];
        MediaLib.weapons[0] = Misc.loadImage("/res/client/menuicons/weapon1.png");
        MediaLib.weapons[1] = Misc.loadImage("/res/client/menuicons/weapon2.png");
        MediaLib.weapons[2] = Misc.loadImage("/res/client/menuicons/weapon3.png");
        MediaLib.weapons[3] = Misc.loadImage("/res/client/menuicons/weapon4.png");
        teams = new BufferedImage[3];
        MediaLib.teams[0] = Misc.loadImage("/res/client/menuicons/random.png");
        MediaLib.teams[1] = Misc.loadImage("/res/client/menuicons/red.png");
        MediaLib.teams[2] = Misc.loadImage("/res/client/menuicons/blue.png");
        extras = new BufferedImage[6];
        MediaLib.extras[0] = Misc.loadImage("/res/client/menuicons/extra1.png");
        MediaLib.extras[1] = Misc.loadImage("/res/client/menuicons/extra2.png");
        MediaLib.extras[2] = Misc.loadImage("/res/client/menuicons/extra3.png");
        MediaLib.extras[3] = Misc.loadImage("/res/client/menuicons/extra4.png");
        MediaLib.extras[4] = Misc.loadImage("/res/client/menuicons/extra5.png");
        MediaLib.extras[5] = Misc.loadImage("/res/client/menuicons/extra6.png");
        looks = new BufferedImage[4];
        MediaLib.looks[0] = Misc.loadImage("/res/client/map/look_assault.png");
        MediaLib.looks[1] = Misc.loadImage("/res/client/map/look_shotgun.png");
        MediaLib.looks[2] = Misc.loadImage("/res/client/map/look_sniper.png");
        MediaLib.looks[3] = Misc.loadImage("/res/client/map/look_mk14.png");
        team = new BufferedImage[2];
        MediaLib.team[0] = Misc.loadImage("/res/client/map/team1.png");
        MediaLib.team[1] = Misc.loadImage("/res/client/map/team2.png");
        BufferedImage img = objects[0][0];
        MediaLib.objects[0][0] = Misc.getReplacedColorInstance(img, new Color(255, 0, 255).getRGB(), new Color(30, 30, 30).getRGB());
        img.flush();
        img = objects[0][1];
        MediaLib.objects[0][1] = Misc.getReplacedColorInstance(img, new Color(255, 0, 255).getRGB(), new Color(30, 30, 30).getRGB());
        img.flush();
        sounds = new SmallSound[soundnames.length];
        int i = 0;
        while (i < sounds.length) {
            MediaLib.sounds[i] = SmallSound.load("/res/client/sound/" + soundnames[i] + ".wav");
            ++i;
        }
        fontScoreTitle = new Font("Verdana", 1, 40);
        fontScore = new Font("Verdana", 0, 20);
        fontScoreInfo = new Font("Verdana", 2, 18);
        fontUi = new Font("Verdana", 0, 25);
        fontUiBig = new Font("Verdana", 1, 32);
        fontPlayer = new Font("Verdana", 0, 15);
        fontInput = new Font("Verdana", 0, 20);
        fontBig = new Font("Verdana", 1, 40);
        fontInfo = new Font("Verdana", 3, 20);
        fontKillfeed = new Font("Verdana", 0, 20);
        MediaLib.playSound(0);
        loaded = true;
        MediaLib.checkDisplayUpdate();
    }

    public static void destroy() {
        MediaLib.tryDestroy(mapBG);
        MediaLib.tryDestroy(fowcircle);
        MediaLib.tryDestroy(weapons);
        MediaLib.tryDestroy(looks);
    }

    private static void tryDestroy(Image img) {
        if (img != null) {
            img.flush();
        }
    }

    private static void tryDestroy(Image[] imgs) {
        if (imgs != null) {
            int i = 0;
            while (i < imgs.length) {
                MediaLib.tryDestroy(imgs[i]);
                ++i;
            }
        }
    }

    public static int getLookSize(int waffe) {
        switch (waffe) {
            case 0: {
                return 200;
            }
            case 1: {
                return 100;
            }
            case 2: {
                return 300;
            }
            case 3: {
                return 300;
            }
        }
        return 0;
    }

    public static void playSound(int sound, float volume, float balance) {
        if (playSound && playSound2 && sound >= 0 && sound < sounds.length && sounds[sound] != null) {
            sounds[sound].play(1.0f * volume, balance);
        }
    }

    public static void playSound(int sound) {
        if (playSound && playSound2 && sound >= 0 && sound < sounds.length && sounds[sound] != null) {
            sounds[sound].play(1.0f, 0.0f);
        }
    }

    public static boolean loadMap(String map) {
        if (mapBG != null) {
            mapBG.flush();
        }
        if ((mapBG = Misc.loadImage("/res/server/maps/" + map + ".png")) == null) {
            mapBG = Misc.loadImage("maps/" + map + ".png");
        }
        return mapBG != null;
    }
}

