/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client.objects;

import com.iosoft.fgalpha.client.Gamestate;
import com.iosoft.fgalpha.client.objects.Medkit;
import com.iosoft.fgalpha.client.objects.Player;
import com.iosoft.fgalpha.client.objects.Projectile;
import com.iosoft.fgalpha.client.objects.Renderable;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Vector2D;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class ClientObj
implements Renderable {
    public int id;
    public boolean visible = true;
    public double rotation;
    public Vector2D pos = new Vector2D(0.0, 0.0);
    public static Gamestate gs;

    public void setPos(double x, double y, double rotation) {
        this.pos.x = x;
        this.pos.y = y;
        this.rotation = rotation;
    }

    public static double makeRotation(short s) {
        return (double)s / 32767.0 * 2.0 * Math.PI;
    }

    public void init(DataInputStream in) throws IOException {
        this.id = in.readInt();
        this.pos.x = in.readFloat();
        this.pos.y = in.readFloat();
        this.rotation = ClientObj.makeRotation(in.readShort());
        this.visible = Misc.readByte(in.readByte())[0];
    }

    public static ClientObj create(int type, DataInputStream in) throws IOException {
        ClientObj o = null;
        switch (type) {
            case 1: {
                o = new Player();
                break;
            }
            case 2: {
                o = new Projectile();
                break;
            }
            case 3: {
                o = new Medkit();
                break;
            }
            default: {
                System.out.println("WARNING: Server sent obj class " + type + ", which is not defined");
            }
        }
        if (o != null) {
            o.init(in);
        }
        return o;
    }
}

