/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.client.objects.ClientObj;
import com.iosoft.fgalpha.client.objects.Player;
import com.iosoft.fgalpha.client.ui.MediaLib;
import com.iosoftware.helpers.Misc;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Gamestate {
    public Object lock;
    public int timelimit;
    public int pointlimit;
    public int serverPort;
    public int maxPlayers;
    public int gamemode;
    public String map;
    public String mapname;
    public String serverVersion;
    public String serverIP;
    public boolean serverLocal;
    public boolean serverNodelay;
    public boolean showRendertime;
    public boolean showScore;
    public boolean ready;
    public boolean paused;
    public List<Player> laggers;
    public List<Player> stats;
    public List<ClientObj> objs;
    public List<Killfeed> killfeed;
    public Player me;
    public Point renderAt;
    public Point mouseAt;
    public int hitmarker;
    private static final Color COLOR_PAUSESCREEN = new Color(180, 180, 180, 150);
    private static final Color COLOR_PAUSE = new Color(200, 200, 100);
    private String[] wpns;
    private String[] xtrs;
    private String[] tms;

    public Gamestate(Object lock) {
        this.lock = lock;
        ClientObj.gs = this;
        this.objs = new ArrayList<ClientObj>();
        this.laggers = new ArrayList<Player>();
        this.stats = new ArrayList<Player>();
        this.killfeed = new ArrayList<Killfeed>();
        this.reset();
    }

    public void addKillfeed(int pl1, int pl2, int pl3, int weapon) {
        Player p1 = this.getPlayer(pl1);
        Player p2 = this.getPlayer(pl2);
        Player p3 = this.getPlayer(pl3);
        this.killfeed.add(new Killfeed(p1, p2, p3, weapon));
    }

    public void addChatMsg(int iSender, String sMsg) {
        Player p = this.getPlayer(iSender);
        this.killfeed.add(new ChatMsg(p, sMsg));
    }

    public void doHitmarker(int strength) {
        int newHM;
        if (strength > 0) {
            MediaLib.playSound(25);
        }
        if ((newHM = strength * 5 + 50) > this.hitmarker) {
            this.hitmarker = newHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.wpns = FightgameAlpha.get().getWeapons();
            this.xtrs = FightgameAlpha.get().getExtras();
            this.tms = FightgameAlpha.get().getTeams();
            this.hitmarker = 0;
            this.showRendertime = false;
            this.serverVersion = "";
            this.map = "";
            this.renderAt = new Point(0, 0);
            this.mouseAt = new Point(0, 0);
            this.objs.clear();
            this.laggers.clear();
            this.stats.clear();
            int iC = this.killfeed.size();
            int i = 0;
            while (i < iC) {
                this.killfeed.get(i).flush();
                ++i;
            }
            this.killfeed.clear();
            this.ready = false;
        }
    }

    public void sortStats() {
        boolean sorted;
        int iC = this.stats.size();
        if (iC < 2) {
            return;
        }
        do {
            sorted = true;
            int i = 0;
            while (i < iC - 1) {
                Player p1 = this.stats.get(i);
                Player p2 = this.stats.get(i + 1);
                if (p1.kills < p2.kills) {
                    sorted = false;
                    Collections.swap(this.stats, i, i + 1);
                }
                ++i;
            }
        } while (!sorted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerVersion() {
        Object object = this.lock;
        synchronized (object) {
            return this.serverVersion;
        }
    }

    public ClientObj getObjByID(int id) {
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            ClientObj o = this.objs.get(i);
            if (o.id == id) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public Player getPlayer(int nr) {
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            ClientObj o = this.objs.get(i);
            if (o instanceof Player && ((Player)o).nr == nr) {
                return (Player)o;
            }
            ++i;
        }
        return null;
    }

    public void removeEntity(int id) {
        ClientObj o = this.getObjByID(id);
        if (o != null) {
            this.objs.remove(o);
        }
    }

    public void setPos(int iID, double dX, double dY, double dRot) {
        ClientObj o = this.getObjByID(iID);
        if (o == null) {
            System.out.println("Warning: Server sent setPos with ID " + iID + " but such object doesn't exist");
            return;
        }
        o.setPos(dX, dY, dRot);
    }

    public String getWeaponName(int weapon) {
        if (weapon < this.wpns.length && weapon >= 0) {
            return this.wpns[weapon];
        }
        return "weapon " + weapon;
    }

    public String getExtraName(int extra) {
        if (extra < this.xtrs.length && extra >= 0) {
            return this.xtrs[extra];
        }
        return "extra " + extra;
    }

    public String getTeamName(int team) {
        if (this.gamemode == 0) {
            return "Free For All";
        }
        if (team + 1 < this.tms.length && team + 1 >= 0) {
            return this.tms[team + 1];
        }
        return "team " + team;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D g) {
        try {
            long time = System.nanoTime();
            Object object = this.lock;
            synchronized (object) {
                if (this.ready) {
                    int i;
                    double atY;
                    double atX;
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillRect(0, 0, 800, 600);
                    AffineTransform t = g.getTransform();
                    double scale = 1.0;
                    if (this.me.extras[3]) {
                        scale = 0.75;
                    }
                    g.translate(300.0 - (double)this.renderAt.x * scale, 300.0 - (double)this.renderAt.y * scale);
                    if (scale != 1.0) {
                        g.scale(scale, scale);
                    }
                    AffineTransform t2 = g.getTransform();
                    if (MediaLib.mapBG != null) {
                        g.drawImage((Image)MediaLib.mapBG, 0, 0, null);
                    }
                    g.setColor(Color.RED);
                    if (!this.me.dead) {
                        Player s = this.me;
                        atX = s.pos.x;
                        atY = s.pos.y;
                        g.rotate(s.rotation, atX, atY);
                        int weapon = this.me.weapon;
                        if (weapon < 4) {
                            g.drawImage((Image)MediaLib.looks[this.me.weapon], (int)atX, (int)atY - MediaLib.getLookSize(this.me.weapon) / 2, null);
                        }
                        g.setTransform(t2);
                    }
                    int iC = this.objs.size();
                    int i2 = 0;
                    while (i2 < iC) {
                        ClientObj o = this.objs.get(i2);
                        if (o.visible) {
                            atX = o.pos.x;
                            atY = o.pos.y;
                            g.translate(atX, atY);
                            g.rotate(o.rotation, 0.0, 0.0);
                            o.render(g);
                            g.setTransform(t2);
                        }
                        ++i2;
                    }
                    g.setTransform(t);
                    g.drawImage((Image)MediaLib.fowcircle, 0, 0, null);
                    g.drawImage((Image)MediaLib.ui, 600, 0, null);
                    g.setColor(Color.BLACK);
                    g.setFont(MediaLib.fontUi);
                    g.translate(625, 0);
                    Misc.drawShadowedCenteredString(this.me.name, 0, 0, 175, 40, g);
                    g.setColor(Color.BLACK);
                    g.fillRect(60, 50, 106, 40);
                    g.setColor(Color.RED);
                    g.fillRect(63, 53, (int)((double)this.me.hp * 1.0), 34);
                    g.setColor(Color.BLACK);
                    g.drawImage((Image)MediaLib.medkit, 5, 50, null);
                    g.drawImage((Image)MediaLib.scoreKills, 5, 90, null);
                    g.drawImage((Image)MediaLib.scoreAssists, 12, 137, null);
                    g.drawImage((Image)MediaLib.scoreDeaths, 5, 170, null);
                    g.drawImage((Image)MediaLib.scorePing, 5, 210, null);
                    g.drawString("" + this.me.kills, 55, 120);
                    g.drawString("" + this.me.assists, 55, 160);
                    g.drawString("" + this.me.deaths, 55, 200);
                    g.drawString("" + this.me.ping, 55, 240);
                    g.translate(10, 255);
                    g.drawImage((Image)MediaLib.uiAmmo, 0, 15, null);
                    g.drawString("" + this.me.ammo, 45, 40);
                    g.setColor(Color.WHITE);
                    g.fillRect(0, 45, this.me.reload, 24);
                    g.translate(0, 70);
                    g.setFont(MediaLib.fontScore);
                    g.setColor(Color.BLACK);
                    g.drawString(this.getWeaponName(this.me.weapon), 0, 45);
                    if (this.me.weapon < MediaLib.weapons.length) {
                        g.drawImage(MediaLib.weapons[this.me.weapon], 0, 50, 150, 50, null);
                    }
                    g.translate(0, 80);
                    g.drawString(this.getExtraName(this.me.extra), 0, 45);
                    if (this.me.extra < MediaLib.extras.length) {
                        g.drawImage(MediaLib.extras[this.me.extra], 0, 50, 150, 50, null);
                    }
                    g.translate(0, 80);
                    g.drawString(this.getTeamName(this.me.team), 0, 45);
                    if (this.me.team < MediaLib.teams.length) {
                        g.drawImage(MediaLib.teams[this.gamemode == 0 ? 0 : this.me.team + 1], 0, 50, 150, 50, null);
                    }
                    g.setTransform(t);
                    g.setColor(Color.BLACK);
                    iC = this.laggers.size();
                    if (iC > 0) {
                        int h = 50 + iC * 40 + 5;
                        int top = 10;
                        g.setColor(Color.BLACK);
                        g.fillRect(7, top - 3, 306, h);
                        g.setColor(Color.WHITE);
                        g.fillRect(10, top, 300, h - 6);
                        g.setColor(Color.BLACK);
                        g.setFont(MediaLib.fontUiBig);
                        Misc.drawVerticalCenteredString("Laggers:", 10, 10, 40, g);
                        g.setFont(MediaLib.fontUi);
                        i = 0;
                        while (i < iC) {
                            Player p = this.laggers.get(i);
                            Misc.drawVerticalCenteredString(p.name, 10, top + 50 + i * 40, 40, g);
                            ++i;
                        }
                    }
                    iC = this.killfeed.size();
                    i = 0;
                    while (i < iC) {
                        Killfeed k = this.killfeed.get(i);
                        k.touch(g);
                        int x = 800 - k.width - 10;
                        int y = 600 - k.pos;
                        if (y >= 600) break;
                        if (x < 10) {
                            x = 10;
                        }
                        g.translate(x, y);
                        k.render(g);
                        g.setTransform(t);
                        ++i;
                    }
                    if (this.hitmarker > 0) {
                        Composite c = g.getComposite();
                        if (this.hitmarker < 25) {
                            g.setComposite(AlphaComposite.getInstance(3, (float)this.hitmarker / 25.0f));
                        }
                        Stroke strk = g.getStroke();
                        g.setStroke(new BasicStroke(8.0f, 1, 1));
                        g.setColor(Color.BLACK);
                        this.drawHitmarker(g);
                        g.setStroke(new BasicStroke(4.0f, 1, 1));
                        g.setColor(Color.WHITE);
                        this.drawHitmarker(g);
                        g.setStroke(strk);
                        g.setComposite(c);
                    }
                    if (this.paused) {
                        g.setColor(COLOR_PAUSESCREEN);
                        g.fillRect(200, 275, 200, 50);
                        g.setColor(COLOR_PAUSE);
                        g.setFont(MediaLib.fontBig);
                        Misc.drawShadowedCenteredString("PAUSE", 0, 0, 600, 600, g);
                    }
                    if (this.showScore) {
                        Composite c = g.getComposite();
                        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
                        g.setColor(Color.DARK_GRAY);
                        g.fillRect(50, 50, 700, 500);
                        g.setComposite(c);
                        g.setColor(Color.LIGHT_GRAY);
                        g.setFont(MediaLib.fontScoreTitle);
                        Misc.drawShadowedCenteredString("Score", 50, 50, 700, 50, g);
                        g.drawImage((Image)MediaLib.scoreKills, 420, 120, null);
                        g.drawImage((Image)MediaLib.scoreDeaths, 490, 120, null);
                        g.drawImage((Image)MediaLib.scoreAssists, 567, 127, null);
                        g.drawImage((Image)MediaLib.scorePing, 630, 120, null);
                        g.setFont(MediaLib.fontScore);
                        int iC2 = this.stats.size();
                        int space = 30;
                        i = 0;
                        while (i < iC2) {
                            Player p = this.stats.get(i);
                            if (p.connected) {
                                g.setColor(Color.BLACK);
                                if (p.ai) {
                                    g.drawImage((Image)MediaLib.scoreAI, 75, 172 + i * space, null);
                                } else {
                                    g.drawString("" + p.ping, 630, 200 + i * space);
                                }
                                if (p.dead) {
                                    g.drawImage((Image)MediaLib.scoreDead, 105, 182 + i * space, null);
                                }
                                g.drawImage((Image)MediaLib.scoreClass[p.weapon < 3 ? p.weapon : 3], 127, 182 + i * space, null);
                                g.drawImage(MediaLib.scoreExtras[p.extra < 6 ? p.extra + 1 : 0], 147, 182 + i * space, 20, 20, null);
                                if (this.gamemode == 1) {
                                    g.setColor(p.team == 0 ? Color.RED : Color.BLUE);
                                }
                                g.drawString(p.name, 166, 200 + i * space);
                                g.setColor(Color.BLACK);
                                g.drawString("" + p.kills, 420, 200 + i * space);
                                g.drawString("" + p.deaths, 490, 200 + i * space);
                                g.drawString("" + p.assists, 560, 200 + i * space);
                            } else {
                                g.setColor(Color.LIGHT_GRAY);
                                g.drawString("Connecting...", 120, 200 + i * space);
                            }
                            ++i;
                        }
                        g.setColor(Color.LIGHT_GRAY);
                        g.setFont(MediaLib.fontScoreInfo);
                        g.drawString(String.valueOf(this.serverIP) + ":" + this.serverPort + " - Version " + this.serverVersion, 80, 470);
                        g.drawString("IoLib v1.3.0", 80, 500);
                        g.drawString("up to " + this.maxPlayers + " human players", 300, 500);
                        g.drawString("Map: " + this.mapname, 80, 530);
                    }
                    if (this.showRendertime) {
                        g.setFont(MediaLib.fontUi);
                        g.setColor(Color.BLUE);
                        g.drawString("Zeit: " + (System.nanoTime() - time) / 1000000L + " ms", 600, 600);
                    }
                } else {
                    g.setColor(Color.BLACK);
                    g.drawString("CANNOT RENDER, NOT READY", 200, 200);
                }
            }
        }
        catch (Exception ex) {
            try {
                Misc.createDirs("C:/FGADump/");
                PrintStream ps = new PrintStream(new File("C:/FGADump/FGAGamestate.txt"));
                ex.printStackTrace(ps);
                ps.flush();
                ps.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Crash! Dump written to C:/FGADump/FGAGamestate.txt");
            System.out.flush();
            System.exit(-1);
        }
    }

    private void drawHitmarker(Graphics2D g) {
        int x = this.mouseAt.x;
        int y = this.mouseAt.y;
        g.drawLine(x - 25, y - 25, x - 10, y - 10);
        g.drawLine(x + 25, y - 25, x + 10, y - 10);
        g.drawLine(x - 25, y + 25, x - 10, y + 10);
        g.drawLine(x + 25, y + 25, x + 10, y + 10);
    }

    public void tick() {
        if (this.hitmarker > 0) {
            --this.hitmarker;
        }
        int iC = this.killfeed.size();
        int i = 0;
        while (i < iC) {
            Killfeed k = this.killfeed.get(i);
            k.tick();
            if (k.pos >= 250 + k.height) {
                k.prerendered.flush();
                this.killfeed.remove(i);
                --iC;
                --i;
            }
            ++i;
        }
    }

    public class ChatMsg
    extends Killfeed {
        private Color color;
        private String name;
        private String msg;
        public int shift;

        public ChatMsg(Player p, String msg) {
            if (p != null) {
                msg = ": " + msg;
                this.name = p.name;
                this.color = Gamestate.this.gamemode == 0 ? Color.DARK_GRAY : (p.team == 0 ? Color.RED : Color.BLUE);
            }
            this.msg = msg;
            this.height = 40;
            this.init();
        }

        @Override
        public void tick() {
            ++this.pos;
        }

        @Override
        public void touch(Graphics2D g) {
            if (this.width == -1) {
                g.setFont(MediaLib.fontKillfeed);
                this.shift = 5;
                if (this.name != null) {
                    this.shift += Misc.stringLength(this.name, g);
                }
                this.width = this.shift + Misc.stringLength(this.msg, g) + 5;
            }
        }

        @Override
        public void prerender(Graphics2D g) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.WHITE);
            g.fillRect(2, 2, this.width - 4, this.height - 4);
            g.setFont(MediaLib.fontKillfeed);
            if (this.name != null) {
                g.setColor(this.color);
                g.drawString(this.name, 5, 25);
            }
            g.setColor(Color.BLACK);
            g.drawString(this.msg, this.shift, 25);
        }
    }

    public class Killfeed {
        private BufferedImage prerendered;
        static final int MAXPOS = 250;
        public int width = -1;
        public int height;
        public int pos;
        private String name1;
        private String name2;
        private String name3;
        private int weapon;
        private int team1;
        private int team2;
        private int team3;
        private int draw1;
        private int draw2;
        private int draw3;
        private int draw4;
        private int draw5;

        protected Killfeed() {
        }

        public Killfeed(Player p1, Player p2, Player p3, int weapon) {
            this();
            this.height = 40;
            this.name1 = "";
            this.name2 = null;
            this.name3 = "";
            this.team1 = 255;
            this.team2 = 255;
            this.team3 = 255;
            if (p1 != null) {
                this.name1 = p1.name;
                this.team1 = p1.team;
            }
            if (p2 != null) {
                this.name2 = p2.name;
                this.team2 = p2.team;
            }
            if (p3 != null) {
                this.name3 = p3.name;
                this.team3 = p3.team;
            }
            this.weapon = weapon;
            this.init();
        }

        protected void init() {
            int iC = Gamestate.this.killfeed.size();
            if (iC == 0) {
                this.pos = 0;
            } else {
                Killfeed k = Gamestate.this.killfeed.get(iC - 1);
                this.pos = k.pos < this.height ? k.pos - this.height : 0;
            }
            this.prerendered = new BufferedImage(800, this.height, 2);
            Graphics2D g = this.prerendered.createGraphics();
            this.touch(g);
            this.prerender(g);
            g.dispose();
        }

        public void tick() {
            ++this.pos;
        }

        public void touch(Graphics2D g) {
            g.setFont(MediaLib.fontKillfeed);
            if (this.width == -1) {
                int w1 = Misc.stringLength(this.name1, g);
                int w2 = this.name2 == null ? 0 : Misc.stringLength(" + ", g);
                int w3 = Misc.stringLength(this.name2 == null ? "" : this.name2, g);
                int w4 = this.weapon < 4 ? 75 : 25;
                int w5 = Misc.stringLength(this.name3, g);
                this.draw1 = 5;
                this.draw2 = this.draw1 + w1;
                this.draw3 = this.draw2 + w2;
                this.draw4 = this.draw3 + w3 + 2;
                this.draw5 = this.draw4 + w4 + 2;
                this.width = this.draw5 + w5 + 5;
            }
        }

        public void render(Graphics2D g) {
            if (this.pos > 250) {
                Composite c = g.getComposite();
                float alpha = 1.0f - (float)(this.pos - 250) / (float)this.height;
                g.setComposite(AlphaComposite.getInstance(10, alpha));
                g.drawImage((Image)this.prerendered, 0, 0, null);
                g.setComposite(c);
            } else {
                g.drawImage((Image)this.prerendered, 0, 0, null);
            }
        }

        public void prerender(Graphics2D g) {
            g.setFont(MediaLib.fontKillfeed);
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.WHITE);
            g.fillRect(2, 2, this.width - 4, this.height - 4);
            g.setColor(this.getColor(this.team1));
            g.drawString(this.name1, this.draw1, 25);
            if (this.name2 != null) {
                g.setColor(Color.BLACK);
                g.drawString(" + ", this.draw2, 25);
                g.setColor(this.getColor(this.team2));
                g.drawString(this.name2, this.draw3, 25);
            }
            if (this.weapon < 4) {
                g.drawImage((Image)MediaLib.killfeedWeapons[this.weapon], this.draw4, 5, null);
            } else {
                g.drawImage(MediaLib.scoreDeaths, this.draw4, 5, 25, 25, null);
            }
            g.setColor(this.getColor(this.team3));
            g.drawString(this.name3, this.draw5, 25);
        }

        public Color getColor(int team) {
            return Gamestate.this.gamemode == 0 ? Color.BLACK : (team == 0 ? Color.RED : (team == 1 ? Color.BLUE : Color.BLACK));
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.flush();
        }

        public void flush() {
            if (this.prerendered != null) {
                this.prerendered.flush();
            }
        }
    }
}

